IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_Sp_CancelImportationWave]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_Sp_CancelImportationWave]
GO
CREATE PROCEDURE [dbo].[VX_Sp_CancelImportationWave](
                @importationWaveNo INT)
AS
  DELETE FROM historicResponse
  WHERE       respondent IN (SELECT resrespondent
                                FROM   respondent a,
                                       historicResponse b
                                WHERE  a.resrespondent = b.respondent
                                       AND a.reswaveimportno = @importationWaveNo
                                       AND a.rescall = 0
                                       AND a.rescompleted = 0)
  DELETE FROM historic
  WHERE       hisrespondent IN (SELECT resrespondent
                                FROM   respondent a,
                                       historic b
                                WHERE  a.resrespondent = b.hisrespondent
                                       AND a.reswaveimportno = @importationWaveNo
                                       AND a.rescall = 0
                                       AND a.rescompleted = 0)
  DELETE FROM note
  WHERE       notrespondent IN (SELECT resrespondent
                                FROM   respondent a,
                                       note b
                                WHERE  a.resrespondent = b.notrespondent
                                       AND a.reswaveimportno = @importationWaveNo
                                       AND a.rescall = 0
                                       AND a.rescompleted = 0)
  DELETE FROM response
  WHERE       rpsrespondent IN (SELECT resrespondent
                                FROM   respondent a,
                                       response b
                                WHERE  a.resrespondent = b.rpsrespondent
                                       AND a.reswaveimportno = @importationWaveNo
                                       AND a.rescall = 0
                                       AND a.rescompleted = 0)
  DELETE FROM timeslothit
  WHERE       tshrespondent IN (SELECT resrespondent
                                FROM   respondent a,
                                       timeslothit b
                                WHERE  a.resrespondent = b.tshrespondent
                                       AND a.reswaveimportno = @importationWaveNo
                                       AND a.rescall = 0
                                       AND a.rescompleted = 0)
  DELETE FROM stratum
  WHERE       strrespondent IN (SELECT resrespondent
                                FROM   respondent a,
                                       stratum b
                                WHERE  a.resrespondent = b.strrespondent
                                       AND a.reswaveimportno = @importationWaveNo
                                       AND a.rescall = 0
                                       AND a.rescompleted = 0)
  DELETE FROM respondent
  WHERE       reswaveimportno = @importationWaveNo
              AND rescall = 0
              AND rescompleted = 0

  DELETE FROM CaseActionHistoryDetail
  WHERE       ActionId = @importationWaveNo
              
  DELETE FROM CaseActionHistory
  WHERE       ActionId = @importationWaveNo

